function [Delta_p_plot,Delta_y_max_obs_plot,Delta_y_plot_bot,Delta_y_plot_top,...
    Delta_y_UR_plot,e_plot,M_a_plot,p_plot,p_2_plot,p_3_plot,p_seismic,...
    p_tilde_2_plot,p_tilde_3_plot,p_tilde_unc_2_plot,p_tilde_unc_3_plot,...
    y_1_plot,y_2_plot,y_3_plot,y_4_plot,...
    y_tilde_1_plot,y_tilde_2_plot,y_tilde_3_plot,y_tilde_4_plot,...
    y_tilde_unc_2_plot,y_tilde_unc_3_plot] = ...
    fault_slip_plot_patch_boundaries...
    (a,colors,Delta_p,Delta_y_max_obs,Delta_y_UR,e_help,flag_check,flag_fric,flag_paper,...
    flag_plot_cap,i,...
    i_max_2_num,i_max_2_tilde,i_max_2_tilde_unc,...
    i_max_3_num,i_max_3_tilde,i_max_3_tilde_unc,...
    M_a,n_plot_max,p,y_1,y_2,y_3,y_4,...
    p_max_bounds,p_min_bounds,...
    y_plot_max_bounds,y_plot_min_bounds,...
    y_tilde_1,y_tilde_2,y_tilde_3,y_tilde_4,y_tilde_unc_2,y_tilde_unc_3)
%
% Creates main plot (slip patch boundaries y_i and y_tilde_i as a function of depletion pr.):
%

% Retrieve colors:
blue = colors(1,:);
green = colors(3,:);

% Truncate plot arrays for y_1, y_4 and e to avoid plotting for pr. below p_seismic or p_min:
Delta_p_plot = Delta_p(1:i);
Delta_y_max_obs_plot = Delta_y_max_obs(1:i);
p_plot = p(1:i);
y_1_plot = y_1(1:i);
y_4_plot = y_4(1:i);
y_tilde_1_plot = y_tilde_1(1:i);
y_tilde_4_plot = y_tilde_4(1:i);
p_seismic = p(i-1); % depletion pressure at which seismicity occurs
Delta_y_UR_plot = Delta_y_UR(1:i);
e_plot = e_help(1:i);
M_a_plot = M_a(1:i);

% Truncate plot arrays for y_2 and y_3 to avoid plotting for press. below p_merge or p_seismic:
p_2_plot = p(1:min(i_max_2_num+1,n_plot_max));
p_3_plot = p(1:min(i_max_3_num+1,n_plot_max));
y_2_plot = y_2(1:min(i_max_2_num+1,n_plot_max));
y_3_plot = y_3(1:min(i_max_3_num+1,n_plot_max));
p_tilde_unc_2_plot = p(1:min(i_max_2_tilde_unc+1,n_plot_max));
p_tilde_unc_3_plot = p(1:min(i_max_3_tilde_unc+1,n_plot_max));
y_tilde_unc_2_plot = y_tilde_unc_2(1:min(i_max_2_tilde_unc+1,n_plot_max));
y_tilde_unc_3_plot = y_tilde_unc_3(1:min(i_max_3_tilde_unc+1,n_plot_max));
p_tilde_2_plot = p(1:min(i_max_2_tilde+1,n_plot_max));
p_tilde_3_plot = p(1:min(i_max_3_tilde+1,n_plot_max));
y_tilde_2_plot = y_tilde_2(1:min(i_max_2_tilde+1,n_plot_max));
y_tilde_3_plot = y_tilde_3(1:min(i_max_3_tilde+1,n_plot_max));
Delta_y_plot_bot = y_tilde_2(1:min(i_max_2_tilde+1,n_plot_max)) - ...
    y_tilde_1(1:min(i_max_2_tilde+1,n_plot_max));
Delta_y_plot_top = y_tilde_4(1:min(i_max_3_tilde+1,n_plot_max)) - ...
    y_tilde_3(1:min(i_max_3_tilde+1,n_plot_max));

if flag_check == 0 && flag_paper == 0
    figure % Slip patch boundaries vs. p_inc
    if flag_fric == 1 % static friction
        hold on
        plot(-p_plot/1e6,y_1_plot,'-','Color',green,'LineWidth',1.5);
        plot(-p_2_plot/1e6,y_2_plot,'-','Color',green,'LineWidth',1.5);
        plot(-p_3_plot/1e6,y_3_plot,'-','Color',green,'LineWidth',1.5);
        plot(-p_plot/1e6,y_4_plot,'-','Color',green,'LineWidth',1.5);
        plot(-p_tilde_unc_2_plot/1e6,y_tilde_unc_2_plot,':','Color',blue,'LineWidth',1.5)
        plot(-p_tilde_unc_3_plot/1e6,y_tilde_unc_3_plot,':','Color',blue,'LineWidth',1.5)
        plot(-p_plot/1e6,y_tilde_1_plot,'-','Color',blue,'LineWidth',1.5)
        plot(-p_tilde_2_plot/1e6,y_tilde_2_plot,'-','Color',blue,'LineWidth',1.5)
        plot(-p_tilde_3_plot/1e6,y_tilde_3_plot,'-','Color',blue,'LineWidth',1.5)
        plot(-p_plot/1e6,y_tilde_4_plot,'-','Color',blue,'LineWidth',1.5)
        line([ 0 35],[   0    0],'LineStyle','-','Color','k','LineWidth',0.5) % horizontal line
        line([ 0 35],[   a    a],'LineStyle',':','Color','k','LineWidth',0.5)
        line([ 0 35],[  -a   -a],'LineStyle',':','Color','k','LineWidth',0.5)
        line([25 25],[y_plot_min_bounds y_plot_max_bounds],'LineStyle','--','Color','k',...
            'LineWidth',0.5)
        % Repeat some of the plots to get them on top of the horizontal lines:
        plot(-p_plot/1e6,y_1_plot,'-','Color',green,'LineWidth',1.5);
        plot(-p_plot/1e6,y_4_plot,'-','Color',green,'LineWidth',1.5);
        hold off
        text(30.3,-75,'$\it y_1$','Interpreter','latex','FontSize',11)
        text(28.9,-20,'$\it y_2$','Interpreter','latex','FontSize',11)
        text(28.8, 20,'$\it y_3$','Interpreter','latex','FontSize',11)
        text(30.3, 75,'$\it y_4$','Interpreter','latex','FontSize',11)
        text(30.3,-88,'$\it \tilde{y}_1$','Interpreter','latex','FontSize',11)
        text(26.8,-20,'$\it \tilde{y}_2$','Interpreter','latex','FontSize',11)
        text(26.7, 20,'$\it \tilde{y}_3$','Interpreter','latex','FontSize',11)
        text(30.3, 88,'$\it \tilde{y}_4$','Interpreter','latex','FontSize',11)
        xlabel('$\it -p$ (MPa)','Interpreter','latex','FontSize',11)
        ylabel('$\it y_i, \tilde{y}_i$ (m)','Interpreter','latex','FontSize',11)
        axis([-p_max_bounds/1e6 -p_min_bounds/1e6 y_plot_min_bounds y_plot_max_bounds])
        box on
    else % slip-weakening or rate and state friction
        hold on
        plot(-p_plot(1:end-1)/1e6,y_tilde_1_plot(1:end-1),'-','Color','red','LineWidth',1.5)
        plot(-p_tilde_2_plot(1:end-1)/1e6,y_tilde_2_plot(1:end-1),'-','Color','red',...
            'LineWidth',1.5)
        plot(-p_tilde_3_plot(1:end-1)/1e6,y_tilde_3_plot(1:end-1),'-','Color','red',...
            'LineWidth',1.5)
        plot(-p_plot(1:end-1)/1e6,y_tilde_4_plot(1:end-1),'-','Color','red','LineWidth',1.5)
        line([ 0 35],[   0    0],'LineStyle','-','Color','k','LineWidth',0.5) % horizontal line
        line([ 0 35],[   a    a],'LineStyle',':','Color','k','LineWidth',0.5)
        line([ 0 35],[  -a   -a],'LineStyle',':','Color','k','LineWidth',0.5)
        line([-p_seismic/1e6 -p_seismic/1e6],[y_plot_min_bounds y_plot_max_bounds],...
            'LineStyle',':','Color','r','LineWidth',0.5)
        hold off
        box on
        p_min_bounds_plot = floor(1.02 * p_seismic/1e6)*1e6;
        text(-p_min_bounds_plot/1e6+0.4,max(y_tilde_1_plot(end-1),y_plot_min_bounds)-5,...
            '$\it \tilde{y}_1$','Interpreter','latex','FontSize',11)
        text(-p_min_bounds_plot/1e6+0.4,y_tilde_2_plot(end-1)+7,'$\it \tilde{y}_2$','Interpreter',...
            'latex','FontSize',11)
        text(-p_min_bounds_plot/1e6+0.4,y_tilde_3_plot(end-1)-5,'$\it \tilde{y}_3$','Interpreter',...
            'latex','FontSize',11)
        text(-p_min_bounds_plot/1e6+0.4,min(y_tilde_4_plot(end-1),y_plot_max_bounds)+7,...
            '$\it \tilde{y}_4$','Interpreter','latex','FontSize',11)
        xlabel('$\it -p$ (MPa)','Interpreter','latex','FontSize',11)
        ylabel('$\tilde{y}_i$ (m)','Interpreter','latex','FontSize',11)
        axis([-p_max_bounds/1e6 -p_min_bounds_plot/1e6 y_plot_min_bounds y_plot_max_bounds])
        box on
    end
    if flag_plot_cap == 1
        [t,s] = title('plot\_patch\_boundaries',' '); % first line: plot file locator
        t.Color = 'r';
        t.FontSize = 10;
        s.FontSize = 10;
        t.FontWeight = 'normal';
        s.FontWeight = 'normal';
    end
end
